function HacerHist(Import, mu,a, b,c,d)
% % % % % ECUACIONES necesarias para extraer ruido entre histogramas
            f=@(x)(a.*b.*x.^(b-1)).*exp(-a.*x.^b);
            g=@(x)pdf('norm',x,c,d);
            frac=@(x)(1-mu).*g(x)./((1-mu).*g(x)+mu.*f(x));
            


figure;
subplot(1,2,1);
[YY,XX] = hist(Import,10);
bar(XX,YY,'BarWidth',1);
xlim([-5 100]);
title('Antes de filtrar');

Weight = frac(Import);
[Hist,Vint] = histwc(Import,Weight,10);

subplot(1,2,2);
bar(Vint,Hist,'BarWidth',1);
xlim([-5 100]);
title('Filtrado');

assignin('base', 'CentroBarras', Vint');
assignin('base', 'AlturaBarra', Hist);

V=Vint'
H=Hist

end

function [histw, vinterval] = histwc(vv, ww, nbins)
  minV  = min(vv);
  maxV  = max(vv);
  delta = (maxV-minV)/nbins;
  vinterval = linspace(minV, maxV, nbins);%-delta/2.0;
  histw = zeros(nbins, 1);
  for i=1:length(vv)
    ind = find(vinterval < vv(i), 1, 'last' );
    if ~isempty(ind)
      histw(ind) = histw(ind) + ww(i);
    end
  end
end